/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Directory;
import cds.aladin.MyProperties;
import cds.tools.Astrodate;
import cds.tools.Util;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class DirectorySort {
    public static final String OTHERS = "Others";
    public static final String PROBLEMATIC = "Problematic";
    public static final String ADDS = "Adds";
    public static final String[] BRANCHES = new String[]{"Image", "Data base", "Catalog", "Cube", "Solar system", "Ancillary", "Outreach", "Deprecated", "Others", "Problematic"};
    public static final String[] PROTOCOLS = new String[]{"HiPS", "SIA2 (image|cube)", "SIA (image)", "SSA (spectrum)", "CS (table)", "TAP (table)"};
    public static final int HIPS = 0;
    public static final int SIA2 = 1;
    public static final int SIA = 2;
    public static final int SSA = 3;
    public static final int CS = 4;
    public static final int TAP = 5;
    public static final String[] DATATYPES = new String[]{"Image", "Cube", "Table", "Spectra"};
    public static final int IMAGE = 0;
    public static final int CUBE = 1;
    public static final int TABLE = 2;
    public static final int SPECTRUM = 3;
    public static final String[] COVRANGES = new String[]{"Whole sky", "75% to 100%", "50% to 75%", "25% to 50%", "10% to 25%", "1% to 10%", "less than 1%"};
    public static final int COV100 = 0;
    public static final int COV75 = 1;
    public static final int COV50 = 2;
    public static final int COV25 = 3;
    public static final int COV10 = 4;
    public static final int COV1 = 5;
    public static final int COV0 = 6;
    public static final String[] REGIMEHIPS = new String[]{"Gamma-ray", "X-ray", "EUV", "UV", "Optical", "Infrared", "Millimeter", "Radio", "Gas-lines"};
    public static final String[][] REGIMEALIAS = new String[][]{{"gammaray", "gamma"}, {"xray", "x"}, {"euv", "extremeultraviolet", "extremeuv"}, {"uv", "ultraviolet"}, {"optical", "optic", "visible"}, {"ir", "infrared"}, {"mm", "millimeter"}, {"radio", "rad"}, {"gaslines", "gasline"}};
    public static final String[] CATCODE = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "B", "J"};
    public static final String[] CATLIB = new String[]{"I-Astrometric Data", "II-Photometric Data", "III-Spectroscopic Data", "IV-Cross-Identifications", "V-Combined data", "VI-Miscellaneous", "VII-Non-stellar Objects", "VIII-Radio and Far-IR data", "IX-High-Energy data", "B-External databases, regularly updated", "Journal table"};
    public static final String[] PLANETS = new String[]{"Sun", "Mercury", "Venus", "Earth", "Mars", "Asteroid belt", "Saturn", "Jupiter", "Uranus", "Neptune", "Pluton"};
    public static final int DEFAULT = 0;
    public static final int BRANCH = 1;
    public static final int NAME = 2;
    public static final int WAVELEN = 3;
    public static final int DATE = 4;
    public static final int COVERAGE = 5;
    public static final int RESOL = 6;
    public static final int REGIME = 7;
    public static final int SIZE = 8;
    public static final int POPULAR = 9;
    public static final int ORIGIN = 10;
    public static final int ID = 11;
    public static final int PROTOCOL = 12;
    public static final int VIZCODE = 13;
    public static final int JOURNAL = 14;
    public static final int JNLVOL = 15;
    public static final int PLANET = 16;
    public static final int CDS = 17;
    public static final int ROWS = 18;
    public static final int COLOR = 19;
    public static final int YEAR = 20;
    public static final int VIZIER = 21;
    public static final int VIZCAT = 22;
    public static final int BRANCH1 = 23;
    public static final int BRANCH2 = 24;
    public static final int DATATYPE = 25;
    public static final int VIZID = 26;
    public static final int VIZCODEFULL = 27;
    private Aladin aladin;
    private SortedMap<String, BranchRules> AllRules;
    private SortRule[] globalRules;
    private int currentGlobal = 0;
    static boolean first = true;

    protected DirectorySort(Aladin aladin) {
        this.aladin = aladin;
        this.initRules();
        this.initGlobal();
    }

    protected JPopupMenu createBranchPopup(String branch) {
        final BranchRules br = this.getBranchRules(branch);
        assert (branch != null);
        JPopupMenu c = new JPopupMenu();
        int i = 0;
        ButtonGroup bg = new ButtonGroup();
        for (SortRule r : br.rules) {
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(r.label);
            Util.toolTip(mi, r.description);
            mi.setActionCommand(i + "");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = Integer.parseInt(e.getActionCommand());
                    br.setCurrent(index);
                    ((DirectorySort)DirectorySort.this).aladin.directory.resumeSort();
                }
            });
            bg.add(mi);
            if (i == br.current) {
                mi.setSelected(true);
            }
            c.add(mi);
            ++i;
        }
        return c;
    }

    protected JPopupMenu createGlobalPopup() {
        JPopupMenu c = new JPopupMenu();
        int i = 0;
        ButtonGroup bg = new ButtonGroup();
        for (SortRule r : this.globalRules) {
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(r.label);
            Util.toolTip(mi, r.description);
            mi.setActionCommand(i + "");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = Integer.parseInt(e.getActionCommand());
                    DirectorySort.this.setCurrentGlobal(index);
                    ((DirectorySort)DirectorySort.this).aladin.directory.resumeSort();
                }
            });
            bg.add(mi);
            if (i == this.currentGlobal) {
                mi.setSelected(true);
            }
            c.add(mi);
            ++i;
        }
        return c;
    }

    protected void setCurrentGlobal(int index) {
        this.currentGlobal = index;
    }

    protected void setCurrentRule(String branch, int index) {
        BranchRules br = this.getBranchRules(branch);
        assert (branch != null);
        br.setCurrent(index);
    }

    private void initGlobal() {
        this.globalRules = new SortRule[]{new SortRule("Default (branch by branch)", "Default sort/hierarchy based on branch rules managed by CDS", new int[0]), new SortRule("Origin", "By ascending name, grouped by origin", new int[]{10, 2}), new SortRule("Regime", "By ascending wave lenght, grouped by regime", new int[]{7, 3}), new SortRule("Protocol", "By ascending name, grouped by protocol", new int[]{12, 2}), new SortRule("Data type", "By ascending name, grouped by data type", new int[]{25, 2}), new SortRule("Coverage", "Descending coverage, grouped by coverage range", new int[]{5, 11}), new SortRule("Year", "By descending date, grouped by year", new int[]{-20, -4, 2}), new SortRule("Flat name", "By ascending name", new int[]{2}), new SortRule("Flat date", "By descending date", new int[]{-4}), new SortRule("Flat wave lenght", "By ascending wavelen", new int[]{3})};
        this.currentGlobal = 0;
    }

    private void initRules() {
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return (s2.length() - s1.length()) * 10000 + s1.compareTo(s2);
            }
        };
        this.AllRules = new TreeMap<String, BranchRules>(comparator);
        this.initBranchRules("", new SortRule[]{new SortRule("Name", "By name, grouped by origin, CDS first", new int[]{1, 17, 10, 2}), new SortRule("Regime", "By regime, grouped by origin", new int[]{1, 10, 7, 2}), new SortRule("Date", "Descending date, grouped by origin", new int[]{1, 10, -4})});
        this.initBranchRules("Data base", new SortRule[]{new SortRule("Name", "By name sorted, CDS first", new int[]{1, 17, 2}), new SortRule("Origin", "By name, grouped by origin", new int[]{1, 10, 23, 2})});
        this.initBranchRules("Image", new SortRule[]{new SortRule("Regime", "Ascending wavelength, grouped by regime", new int[]{1, 7, 24, 3}), new SortRule("Origin", "Ascending wavelength, grouped by origin", new int[]{1, 10, 24, 3}), new SortRule("Coverage", "Ascending wavelength, grouped by coverage range", new int[]{1, 5, 24, 3})});
        this.initBranchRules("Cube", new SortRule[]{new SortRule("Regime", "Ascending wavelength, grouped by regime", new int[]{1, 7, 3}), new SortRule("Origin", "Ascending wavelength, grouped by origin", new int[]{1, 10, 3}), new SortRule("Coverage", "Ascending wavelength, grouped by coverage range", new int[]{1, 5, 3})});
        this.initBranchRules("Catalog", new SortRule[]{new SortRule("Regime", "By name, grouped by origin and regime, CDS first", new int[]{1, 17, 10, 7, 2}), new SortRule("Date", "Descending date, grouped by origin", new int[]{1, 17, 10, -20, -4}), new SortRule("Coverage", "Descending coverage, grouped by coverage range", new int[]{1, 17, 10, 5, 11})});
        this.initBranchRules("Catalog/VizieR", new SortRule[]{new SortRule("Default", "based on size, popularity and date (all descending), grouped by VizieR category and catalogue name", new int[]{1, 21, 13, 14, 22, -15, 8, 9, -4}), new SortRule("Regime", "based on size, popularity and date (all descending), grouped by regime and catalogue name", new int[]{1, 21, 7, 22, 8, 9, -4}), new SortRule("Size", "Descending table size", new int[]{1, 21, 18}), new SortRule("Popularity", "Descending popularity", new int[]{1, 21, 9}), new SortRule("Date", "Descending date, grouped by year and catalogue name", new int[]{1, 21, -20, -4, 22}), new SortRule("Coverage", "Descending coverage, grouped by coverage range", new int[]{1, 21, 5, 11}), new SortRule("Identifier", "Ascending ID, grouped by VizieR category and catalogue number", new int[]{1, 21, 27, 26})});
        this.initBranchRules("Outreach", new SortRule[]{new SortRule("Name", "By acending name", new int[]{1, 2}), new SortRule("Origin", "By name, grouped by origin", new int[]{1, 10, 23, 2})});
        this.initBranchRules("Ancillary", new SortRule[]{new SortRule("Name", "By acending name", new int[]{1, 2}), new SortRule("Origin", "By name, grouped by origin", new int[]{1, 10, 23, 2})});
        this.initBranchRules(OTHERS, new SortRule[]{new SortRule("Protocol", "By name, grouped by protocol and origin", new int[]{1, 12, 10, 2}), new SortRule("Data type", "By name, grouped by data type and origin", new int[]{1, 25, 10, 2}), new SortRule("Regime", "Sorted by regime, grouped by protocol and origin", new int[]{1, 7, 10, 12, 2}), new SortRule("Origin", "Descending date, grouped by protocol and origin", new int[]{1, 10, 12, 2}), new SortRule("Date", "Descending date, grouped by protocol and origin", new int[]{1, -20, -4, 10, 12, 2})});
        this.initBranchRules("Solar system", new SortRule[]{new SortRule("Planet", "by resolution, grouped by Planet name", new int[]{1, 16, 6, 2}), new SortRule("Date", "Descending date, grouped by year", new int[]{1, 20, 4})});
        this.initBranchRules("Deprecated", new SortRule[]{new SortRule("Protocol", "Ascending wavelength, grouped by protocol and origin", new int[]{1, 12, 10, 3}), new SortRule("Regime", "Ascending wavelength, grouped by regime", new int[]{1, 24, 3}), new SortRule("Name", "By name, grouped by origin", new int[]{1, 10, 2}), new SortRule("Origin", "Ascending wavelength, grouped by origin", new int[]{1, 10, 3})});
    }

    private void initBranchRules(String branch, SortRule[] rule) {
        this.AllRules.put(branch, new BranchRules(rule));
    }

    protected boolean hasBranchesRules(String branch) {
        for (String cat : this.AllRules.keySet()) {
            if (!branch.startsWith(cat)) continue;
            return true;
        }
        return false;
    }

    private BranchRules getBranchRules(String branch) {
        for (String cat : this.AllRules.keySet()) {
            if (!branch.startsWith(cat)) continue;
            return (BranchRules)this.AllRules.get(cat);
        }
        return null;
    }

    private int[] getSortRule(String branch) {
        BranchRules rules = this.getBranchRules(branch);
        if (rules == null) {
            return null;
        }
        return rules.getCurrentRule();
    }

    protected boolean isGlobalSorted() {
        return this.currentGlobal > 0;
    }

    protected boolean setInternalSortKey(String id, MyProperties prop) {
        int[] mode;
        StringBuilder k1 = new StringBuilder();
        String branch = prop.getFirst("client_category");
        if (this.currentGlobal > 0) {
            mode = this.globalRules[this.currentGlobal].rule;
        } else {
            if (branch == null) {
                branch = "";
            }
            mode = this.getSortRule(branch);
        }
        if (mode != null) {
            for (int i = 0; i < mode.length; ++i) {
                int m = mode[i];
                boolean flagLast = i == mode.length - 1;
                String k = this.getSortKey(id, prop, m, flagLast);
                if (k == null) continue;
                k1.append("/" + k);
            }
        }
        if (k1.length() > 0) {
            prop.replaceValue("internal_sort_key", k1.toString());
        } else {
            prop.remove("internal_sort_key");
        }
        k1 = new StringBuilder();
        if (mode != null) {
            for (int m : mode) {
                String k = this.getBranchKey(id, prop, branch, m);
                if (k == null) continue;
                if (k1.length() > 0) {
                    k1.append('/');
                }
                k1.append(k);
            }
        }
        prop.remove("internal_category");
        if (k1.length() > 0) {
            String suffix = branch.startsWith(k1.toString()) ? branch.substring(k1.length()) : "";
            String s = k1.toString() + suffix;
            if (this.isGlobalSorted() || !s.equals(branch)) {
                prop.put("internal_category", s);
            }
        }
        return true;
    }

    private int getBranchIndex(String branch) {
        return Util.indexInArrayOf(Util.getSubpath(branch, 0), BRANCHES);
    }

    public static int getRegimeIndex(String s) {
        if (s == null) {
            return -1;
        }
        StringBuilder s2 = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (!Character.isLetterOrDigit(c)) continue;
            s2.append(Character.toLowerCase(c));
        }
        String s3 = s2.toString();
        for (int i = 0; i < REGIMEALIAS.length; ++i) {
            for (String s1 : REGIMEALIAS[i]) {
                if (!s3.equals(s1)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getDataTypeIndex(MyProperties prop) {
        if (prop.getProperty("hips_service_url") != null) {
            String s = prop.getFirst("dataproduct_type");
            if (s != null) {
                if (Util.indexOfIgnoreCase(s, "catalog") >= 0) {
                    return 2;
                }
                if (Util.indexOfIgnoreCase(s, "cube") >= 0) {
                    return 1;
                }
            }
            return 0;
        }
        if (prop.getProperty("sia_service_url") != null || prop.getProperty("sia2_service_url") != null) {
            return 0;
        }
        if (prop.getProperty("ssa_service_url") != null) {
            return 3;
        }
        if (prop.getProperty("cs_service_url") != null || prop.getProperty("access_url") != null || prop.getProperty("tap_service_url") != null) {
            return 2;
        }
        return -1;
    }

    public static int getProtocolIndex(MyProperties prop) {
        if (prop.getProperty("hips_service_url") != null) {
            return 0;
        }
        if (prop.getProperty("sia2_service_url") != null) {
            return 1;
        }
        if (prop.getProperty("sia_service_url") != null) {
            return 2;
        }
        if (prop.getProperty("ssa_service_url") != null) {
            return 3;
        }
        if (prop.getProperty("cs_service_url") != null || prop.getProperty("access_url") != null) {
            return 4;
        }
        if (prop.getProperty("tap_service_url") != null) {
            return 5;
        }
        return -1;
    }

    private String keyAlpha(String s, boolean flagReverse, int nbDigit) {
        int len = s == null ? 0 : s.length();
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < nbDigit; ++i) {
            if (i >= len) {
                key.append('.');
                continue;
            }
            char c = Character.toUpperCase(s.charAt(i));
            if (flagReverse) {
                if (Character.isDigit(c)) {
                    c = (char)(57 - c);
                } else if (Character.isLetter(c)) {
                    c = (char)(90 - c);
                }
            }
            key.append(c);
        }
        return key.toString();
    }

    private int countSlash(String s) {
        int i = 0;
        for (char c : s.toCharArray()) {
            if (c != '/') continue;
            ++i;
        }
        return i;
    }

    private String getSortKey(String id, MyProperties prop, int mode, boolean flagLast) {
        String branch = prop.getFirst("client_category");
        String key = this.getSortKey1(id, prop, branch, mode);
        if (branch != null && flagLast) {
            int c = this.countSlash(branch);
            assert (c <= 9);
            key = key + (9 - c);
        }
        return key;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getSortKey1(String id, MyProperties prop, String branch, int mode) {
        boolean flagReverse = false;
        if (mode < 0) {
            flagReverse = true;
            mode = -mode;
        }
        switch (mode) {
            case 1: {
                int c = this.getBranchIndex(branch);
                if (c == -1) {
                    c = 99;
                    return String.format("%02d", c);
                } else {
                    if (!flagReverse) return String.format("%02d", c);
                    c = 98 - c;
                }
                return String.format("%02d", c);
            }
            case 2: {
                String name = prop.getFirst("obs_title");
                if (name != null) return this.keyAlpha(name, flagReverse, 4);
                name = prop.getFirst("obs_collection");
                return this.keyAlpha(name, flagReverse, 4);
            }
            case 4: 
            case 20: {
                double mjd = 99999.0;
                try {
                    String date = prop.getFirst("t_min");
                    if (date != null) {
                        mjd = Double.parseDouble(date);
                        if (!flagReverse) return String.format("%05d", (int)mjd);
                        mjd = 99998.0 - mjd;
                        return String.format("%05d", (int)mjd);
                    } else {
                        date = prop.getFirst("bib_year");
                        if (date == null) return String.format("%05d", (int)mjd);
                        mjd = Astrodate.JDToMJD(Astrodate.YdToJD(Double.parseDouble(date)));
                        if (!flagReverse) return String.format("%05d", (int)mjd);
                        mjd = 99998.0 - mjd;
                    }
                    return String.format("%05d", (int)mjd);
                }
                catch (Exception date) {
                    // empty catch block
                }
                return String.format("%05d", (int)mjd);
            }
            case 5: {
                double cov = 9.0;
                try {
                    double w = Double.parseDouble(prop.getFirst("moc_sky_fraction"));
                    cov = Math.log(1.0 + w);
                    if (flagReverse) return String.format("%01.6f", cov);
                    cov = 8.0 - cov;
                    return String.format("%01.6f", cov);
                }
                catch (Exception w) {
                    // empty catch block
                }
                return String.format("%01.6f", cov);
            }
            case 6: {
                int order = 99;
                try {
                    order = Integer.parseInt(prop.getFirst("hips_order"));
                    if (flagReverse) return String.format("%02d", order);
                    order = 98 - order;
                    return String.format("%02d", order);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return String.format("%02d", order);
            }
            case 8: {
                int size = 99;
                try {
                    long r = Long.parseLong(prop.getFirst("nb_rows"));
                    size = (int)Math.log(r + 1L);
                    if (flagReverse) return String.format("%02d", size);
                    size = 98 - size;
                    return String.format("%02d", size);
                }
                catch (Exception r) {
                    // empty catch block
                }
                return String.format("%02d", size);
            }
            case 18: {
                long rows = 0L;
                try {
                    rows = Long.parseLong(prop.getFirst("nb_rows"));
                    if (flagReverse) return String.format("%014d", rows);
                    rows = 99999999999999L - rows;
                    return String.format("%014d", rows);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return String.format("%014d", rows);
            }
            case 3: {
                double wl = 9.0;
                String sw = prop.getFirst("em_min");
                if (sw != null) {
                    try {
                        double w = Double.parseDouble(sw);
                        String wavelen = prop.getFirst("em_max");
                        if (wavelen != null) {
                            w = (w + Double.parseDouble(wavelen)) / 2.0;
                        }
                        wl = Math.log(1.0 + w);
                        if (!flagReverse) return String.format("%01.14f", wl);
                        wl = 9.0 - wl;
                        return String.format("%01.14f", wl);
                    }
                    catch (Exception w) {}
                    return String.format("%01.14f", wl);
                } else {
                    wl = DirectorySort.getRegimeIndex(prop.getFirst("obs_regime"));
                    if (wl == -1.0) {
                        wl = 9.0;
                        return String.format("%01.14f", wl);
                    } else {
                        if (!flagReverse) return String.format("%01.14f", wl);
                        wl = 8.0 - wl;
                    }
                }
                return String.format("%01.14f", wl);
            }
            case 7: {
                boolean isHips = prop.getProperty("hips_service_url") != null;
                String s = prop.getFirst("dataproduct_type");
                boolean isImage = s != null && (s.indexOf("image") >= 0 || s.indexOf("catalog") < 0 && s.indexOf("cube") < 0);
                int c = -1;
                if (isHips && isImage) {
                    c = DirectorySort.getRegimeIndex(Util.getSubpath(branch, 1));
                }
                if (c < 0) {
                    c = DirectorySort.getRegimeIndex(prop.getFirst("obs_regime"));
                }
                if (c == -1) {
                    c = 9;
                    return c + "";
                } else {
                    if (!flagReverse) return c + "";
                    c = 8 - c;
                }
                return c + "";
            }
            case 16: {
                String planet = Util.getSubpath(branch, 1);
                int c = Util.indexInArrayOf(planet, PLANETS);
                if (c == -1) {
                    c = 9;
                    return c + "";
                } else {
                    if (!flagReverse) return c + "";
                    c = 8 - c;
                }
                return c + "";
            }
            case 12: {
                int c = DirectorySort.getProtocolIndex(prop);
                if (c == -1) {
                    c = 9;
                }
                if (!flagReverse) return c + "";
                c = 8 - c;
                return c + "";
            }
            case 13: {
                String code = Directory.getCatCode(id);
                int c = Util.indexInArrayOf(code, CATCODE);
                if (c == -1) {
                    c = 99;
                    return String.format("%02d", c);
                } else {
                    if (!flagReverse) return String.format("%02d", c);
                    c = 98 - c;
                }
                return String.format("%02d", c);
            }
            case 27: {
                String code = Directory.getCatCode(id);
                int c = Util.indexInArrayOf(code, CATCODE);
                if (c == -1) {
                    c = 99;
                }
                String suffix = "";
                if (!code.equals("J")) {
                    String number = Directory.getCatNumber(id);
                    try {
                        int j;
                        int n = number.length();
                        for (j = 0; j < n && Character.isDigit(number.charAt(j)); ++j) {
                        }
                        suffix = String.format("%04d", Integer.parseInt(number.substring(0, j)));
                        if (j >= n) return String.format("%02d", c) + "/" + suffix;
                        suffix = suffix + "/" + number.substring(j + 1);
                        return String.format("%02d", c) + "/" + suffix;
                    }
                    catch (Exception j) {}
                    return String.format("%02d", c) + "/" + suffix;
                }
                String num = Directory.getJournalNum(id);
                int vol = 9999;
                int page = 9999;
                int offset = num.indexOf(47);
                try {
                    vol = Integer.parseInt(num.substring(0, offset));
                    if (flagReverse) {
                        vol = 9998 - vol;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    ++offset;
                    while (offset < num.length() && !Character.isDigit(num.charAt(offset))) {
                        ++offset;
                    }
                    page = Integer.parseInt(num.substring(offset));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                suffix = this.keyAlpha(Directory.getJournalCode(id), flagReverse, 6) + "/" + String.format("%04d", vol) + "/" + String.format("%04d", page);
                return String.format("%02d", c) + "/" + suffix;
            }
            case 9: {
                String popularity = prop.get("vizier_popularity");
                long pop = 99L;
                if (popularity == null) return String.format("%02d", pop);
                try {
                    pop = Long.parseLong(popularity);
                    pop = (int)Math.log(1L + pop);
                    if (flagReverse) return String.format("%02d", pop);
                    pop = 98L - pop;
                    return String.format("%02d", pop);
                }
                catch (Exception offset) {
                    // empty catch block
                }
                return String.format("%02d", pop);
            }
            case 14: {
                if (!id.startsWith("CDS/")) return null;
                if (id.equals("CDS/Simbad")) return null;
                String code = Directory.getCatCode(id);
                if (code == null) return null;
                if (code.equals("J")) return this.keyAlpha(Directory.getJournalCode(id), flagReverse, 6);
                return null;
            }
            case 15: {
                if (!id.startsWith("CDS/")) return null;
                if (id.equals("CDS/Simbad")) return null;
                String code = Directory.getCatCode(id);
                if (code == null) return null;
                if (!code.equals("J")) return null;
                String num = Directory.getJournalNum(id);
                int vol = 9999;
                int page = 9999;
                int offset = num.indexOf(47);
                try {
                    vol = Integer.parseInt(num.substring(0, offset));
                    if (flagReverse) {
                        vol = 9998 - vol;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    ++offset;
                    while (offset < num.length() && !Character.isDigit(num.charAt(offset))) {
                        ++offset;
                    }
                    page = Integer.parseInt(num.substring(offset));
                    return String.format("%04d", vol) + "/" + String.format("%04d", page);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return String.format("%04d", vol) + "/" + String.format("%04d", page);
            }
            case 10: {
                return this.keyAlpha(Util.getSubpath(id, 0).toLowerCase(), flagReverse, 6);
            }
            case 25: {
                int c = DirectorySort.getDataTypeIndex(prop);
                if (c != -1) return c + "";
                c = 9;
                return c + "";
            }
            case 11: {
                return this.keyAlpha(id, flagReverse, 12);
            }
            case 17: {
                if (!id.startsWith("CDS")) return "1";
                return "0";
            }
            case 19: {
                String color = prop.getFirst("dataproduct_subtype");
                if (color == null) return "1";
                if (color.indexOf("color") < 0) return "1";
                return "0";
            }
        }
        return null;
    }

    private String getBranchKey(String id, MyProperties prop, String branch, int mode) {
        String s = this.getBranchKey1(id, prop, branch, mode);
        if (s != null && mode != 23 && mode != 24 && mode != 26) {
            s = s.replace("/", "\\/");
        }
        return s;
    }

    private String getBranchKey1(String id, MyProperties prop, String branch, int mode) {
        if (mode < 0) {
            mode = -mode;
        }
        switch (mode) {
            case 1: {
                int c = this.getBranchIndex(branch);
                return c == -1 ? Util.getSubpath(branch, 0) : BRANCHES[c];
            }
            case 7: {
                boolean isHips = prop.getProperty("hips_service_url") != null;
                String s = prop.getFirst("dataproduct_type");
                boolean isImage = s != null && (s.indexOf("image") >= 0 || s.indexOf("catalog") < 0 && s.indexOf("cube") < 0);
                int c = -1;
                if (isHips && isImage) {
                    c = DirectorySort.getRegimeIndex(Util.getSubpath(branch, 1));
                }
                if (c < 0) {
                    c = DirectorySort.getRegimeIndex(prop.getFirst("obs_regime"));
                }
                if (c >= 0) {
                    return REGIMEHIPS[c];
                }
                return "Unknown regime";
            }
            case 10: {
                return Util.getSubpath(id, 0).toLowerCase();
            }
            case 5: {
                try {
                    double w = Double.parseDouble(prop.getFirst("moc_sky_fraction")) * 100.0;
                    int c = w == 100.0 ? 0 : (w >= 75.0 ? 1 : (w >= 50.0 ? 2 : (w >= 25.0 ? 3 : (w >= 10.0 ? 4 : (w >= 1.0 ? 5 : 6)))));
                    return COVRANGES[c];
                }
                catch (Exception w) {
                    return "Unknown coverage";
                }
            }
            case 21: {
                if (!id.startsWith("CDS/") || id.equals("CDS/Simbad")) {
                    return Util.getSubpath(id, 0);
                }
                return "VizieR";
            }
            case 16: {
                return Util.getSubpath(branch, 1);
            }
            case 25: {
                int c = DirectorySort.getDataTypeIndex(prop);
                return c >= 0 ? DATATYPES[c] : "Unknown datatype";
            }
            case 12: {
                int c = DirectorySort.getProtocolIndex(prop);
                return c >= 0 ? PROTOCOLS[c] : "Unknown protocol";
            }
            case 14: {
                String code;
                if (!id.startsWith("CDS/") || id.equals("CDS/Simbad") || (code = Directory.getCatCode(id)) == null || !code.equals("J")) break;
                String journal = Directory.getJournalCode(id);
                return journal;
            }
            case 13: {
                String code;
                if (!id.startsWith("CDS/") || id.equals("CDS/Simbad") || (code = Directory.getCatCode(id)) == null) break;
                int c = Util.indexInArrayOf(code, CATCODE);
                return c == -1 ? "Unknown cat" : CATLIB[c];
            }
            case 22: {
                String code;
                if (!id.startsWith("CDS/") || id.equals("CDS/Simbad") || (code = Directory.getCatCode(id)) == null) break;
                String parent = Directory.getCatParent(id);
                boolean hasMultiple = this.aladin.directory.hasMultiple(parent);
                if (hasMultiple) {
                    return prop.get("obs_collection");
                }
                return null;
            }
            case 26: {
                if (!id.startsWith("CDS/") || id.equals("CDS/Simbad")) break;
                return Directory.getCatParent(id.substring(4));
            }
            case 20: {
                String year = null;
                String date = prop.getFirst("t_min");
                if (date != null) {
                    try {
                        double mjd = Double.parseDouble(date);
                        year = "" + (int)Astrodate.JDToYd(Astrodate.MJDToJD(mjd));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (year == null) {
                    year = prop.getFirst("bib_year");
                }
                return year == null ? "Unknown date" : year;
            }
            case 23: {
                return Util.getSubpath(branch, 1, -1);
            }
            case 24: {
                return Util.getSubpath(branch, 2, -1);
            }
        }
        return null;
    }

    class BranchRules {
        ArrayList<SortRule> rules = new ArrayList();
        int current = 0;

        BranchRules(SortRule[] rules) {
            for (SortRule r : rules) {
                this.rules.add(r);
            }
        }

        int[] getCurrentRule() {
            return this.rules.get((int)this.current).rule;
        }

        void setCurrent(int index) {
            assert (index >= 0 && index < this.rules.size());
            this.current = index;
            DirectorySort.this.setCurrentGlobal(0);
        }
    }

    class SortRule {
        int[] rule;
        String label;
        String description;

        SortRule(String label, String description, int[] rule) {
            this.label = label;
            this.description = description;
            this.rule = rule;
        }
    }
}

